from skyfield.api import load
import datetime
import matplotlib.pyplot as plt
from skyfield.api import utc


MONTHS = [
    "Jan",
    "Feb",
    "Mär",
    "Apr",
    "Mai",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Okt",
    "Nov",
    "Dez",
]

# Create a timescale and ask the current time.
ts = load.timescale()

# Load the JPL ephemeris DE421 (covers 1900-2050).
planets = load('de421.bsp')
earth, sun = planets['earth'], planets['sun']

alt_list = []
az_list = []
day_list = []

dt = datetime.datetime(2006, 1, 1, 12, 0)

dt = dt.replace(tzinfo=utc)
for day in range(365):
    day_list.append(day)
    t = ts.from_datetime(dt)
    from skyfield.api import N, W, wgs84

    boston = earth + wgs84.latlon(51.5 * N, 0 * W)
    astrometric = boston.at(t).observe(sun)
    alt, az, d = astrometric.apparent().altaz()

    print(alt)
    print(az)

    alt_list.append(alt.degrees)
    az_list.append(az.degrees)

    if dt.day == 1:
        label = f"1. {MONTHS[(dt.month-1)%12]}"
        # label = dt.month
        plt.text(az.degrees, alt.degrees,  label)
    dt += datetime.timedelta(days=1)

#plt.scatter(az_list, alt_list)
plt.scatter(day_list, az_list)
plt.xlabel("Azimut")
plt.ylabel("Elevation")
plt.show()
