import tkinter

from matplotlib.backends.backend_tkagg import (
    FigureCanvasTkAgg, NavigationToolbar2Tk)
from matplotlib.backend_bases import key_press_handler
from matplotlib.figure import Figure
import orbit
import numpy as np


root = tkinter.Tk()
root.wm_title("Analemma")

fig = Figure(figsize=(5, 4), dpi=100)
t = np.arange(0, 3, .01)
plotobj = fig.add_subplot(111)

e_slider = tkinter.Scale(root, from_=0, to=0.2, digits = 4, resolution =   0.0001, length=600, orient=tkinter.HORIZONTAL)
e_slider.pack()

axis_tilt_slider = tkinter.Scale(root, from_=0, to=90, digits = 1, resolution =   0.1, length=600, orient=tkinter.HORIZONTAL)
axis_tilt_slider.pack()

canvas = FigureCanvasTkAgg(fig, master=root)  # A tk.DrawingArea.
def plot():
    eccentricity = e_slider.get()
    axis_tilt = axis_tilt_slider.get()
    plotobj.clear()
    az, el = orbit.get_analemma(e=eccentricity, axis_tilt=axis_tilt)
    plotobj.scatter(az, el)
    canvas.draw()


button = tkinter.Button(master=root, text="Plot", command=plot)
button.pack(side=tkinter.BOTTOM)


canvas.draw()
canvas.get_tk_widget().pack(side=tkinter.TOP, fill=tkinter.BOTH, expand=1)

toolbar = NavigationToolbar2Tk(canvas, root)
toolbar.update()
canvas.get_tk_widget().pack(side=tkinter.TOP, fill=tkinter.BOTH, expand=1)


def on_key_press(event):
    print("you pressed {}".format(event.key))
    key_press_handler(event, canvas, toolbar)


canvas.mpl_connect("key_press_event", on_key_press)


def _quit():
    root.quit()
    root.destroy()
    
button = tkinter.Button(master=root, text="Quit", command=_quit)
button.pack(side=tkinter.BOTTOM)

tkinter.mainloop()
