from __future__ import print_function, division
import numpy as np
from PyAstronomy import pyasl
import matplotlib.pylab as plt
import math
import orbitlib








def get_analemma(e=0.0167086, axis_tilt=23.439281):

    YEAR_LENGTH = 365.256363004
    EXCENTRICITY = 0.0167086
    # EXCENTRICITY = 0.0

    # Instantiate a Keplerian elliptical orbit with
    # semi-major axis of 1.3 length units,
    # a period of 2 time units, eccentricity of 0.5,
    # longitude of ascending node of 70 degrees, an inclination
    # of 10 deg, and a periapsis argument of 110 deg.
    ke = pyasl.KeplerEllipse(149.60 * 10**6, YEAR_LENGTH, e=e, Omega=174.9, i=0.0, w=0.0)

    # Get a time axis
    t = np.linspace(1, 365, 365)

    # Calculate the orbit position at the given points
    # in a Cartesian coordinate system.
    pos = ke.xyzPos(t)

    az_list = []
    el_list = []

    day_rot = 360 / 365.256363004
    print(day_rot)

    lat = 51.0
    lon = 0

    earth_rot = 0
    earth_incl = 23.5

    for p in pos:
        earth_rot += day_rot

        east, north, up = orbitlib.sun_enu_from_earth_ecliptic(p, lat, lon, 30, math.radians(earth_rot), axis_tilt)
        az = np.arctan2(east, north) % (2 * np.pi)
        el = np.arctan2(up, np.sqrt(east**2 + north**2))
        el_list.append(el)
        az_list.append(az)

    return az_list, el_list


if __name__ == "__main__":
    az_list, el_list = get_analemma()
    plt.plot(az_list, el_list)
    plt.show()
