import matplotlib.pyplot as plt
from PyAstronomy import pyasl
import numpy as np
import math
import matplotlib.animation as animation
import orbitlib


def make_animation(e, axial_tilt, last_frame_only=False):
    SUBRES = 50
    YEAR_LENGTH = 32
    EXCENTRICITY = e
    AXIAL_TILT = axial_tilt
    #AXIAL_TILT = 23

    ke = pyasl.KeplerEllipse(1, YEAR_LENGTH, e=EXCENTRICITY, Omega=0.0, i=0.0, w=0.0)

    # Get a time axis
    timeline = np.linspace(0, YEAR_LENGTH, YEAR_LENGTH*SUBRES + 1, endpoint=True)

    # Calculate the orbit position at the given points
    # in a Cartesian coordinate system.
    pos = ke.xyzPos(timeline)

    x_smooth_vals = []
    y_smooth_vals = []
    x_vals = []
    y_vals = []
    angles = []
    angle_diff = []
    angle_diff_smooth = []
    angle_diff_max = 0

    el = []
    az = []

    day_sightlines = []

    angle  = 180

    def get_sightline_xy(x, y, angle, minlen=0):
        if abs(angle) % 360 in [0, 180]:
            linelen = abs(x)
        else:
            linelen = abs(y / (math.sin(math.radians(angle))))
        linelen = max(linelen, minlen)
        return [x, x + math.cos(math.radians(angle)) * linelen], [y, y + math.sin(math.radians(angle)) * linelen]

    fig, axs = plt.subplots(1, 3, gridspec_kw={'width_ratios': [2, 1, 1]})
    for i, (x, y, z) in enumerate(pos):
        x = -x
        y = -y
        sight_angle = math.degrees(math.atan2(y, x)) + 180
        t = timeline[i]
        angle = ((360*(YEAR_LENGTH + 1)) * (i / (YEAR_LENGTH*SUBRES))) % 360


        if i % SUBRES == 0:
            east, north, up = orbitlib.sun_enu_from_earth_ecliptic([x, y, 0], 0, 0, 0, math.radians(angle), AXIAL_TILT)
            az.append(east)
            el.append(north)

            print("enu:", east, north, up)

            d_angle = np.degrees(np.arctan2(-east, np.sqrt(east**2 + up**2)))

            x_vals.append(x)
            y_vals.append(y)
            print(i)
            print(t)
            print("angle =", angle)

            print("d_angle =", d_angle)


            day_sightlines.append(axs[0].plot(*get_sightline_xy(x, y, angle), c="k", zorder=50)[0])
            day_sightlines[-1].set_alpha(0)
            #angle_diff.append(angle - sight_angle)
            angle_diff.append(d_angle)

            angle_diff_max = max(angle_diff_max, abs(angle-sight_angle))

        angles.append(angle)
        x_smooth_vals.append(x)
        y_smooth_vals.append(y)

    angle_diff_max = 2

    az_max = max(max(az), abs(min(az)),)
    el_max = max(max(el), abs(min(el)))
    az_max = max(az_max, 0.1)
    el_max = max(el_max, 0.1)
    el_max = max(az_max*2, el_max)
    az_max = max(el_max/2, az_max)
    angle_diff_max = max(angle_diff_max, 0.2)

    earth = axs[0].plot([pos[0][0]], [pos[0][1]], marker="o", zorder=200, c="b")[0]
    earth_dir = axs[0].plot([pos[0][0]], [pos[0][1]], c="k", alpha=0.8)[0]

    axs[0].set_aspect('equal')
    axs[0].scatter([0], [0], c="y", zorder=10000)
    axs[0].plot(x_smooth_vals, y_smooth_vals, c="k", alpha=0.5)
    axs[0].scatter(x_vals, y_vals, c="b", zorder=100, alpha=0.3)

    eq_time_marker = axs[1].plot([0], [0], marker="o", zorder=100, c="r")[0]
    axs[1].plot(range(YEAR_LENGTH+1), angle_diff, c="k")
    axs[1].set_xlabel("Tag")
    axs[1].set_ylabel("Abweichung von Südrichtung [°]")
    angle_diff_range = max(max(angle_diff), abs(min(angle_diff)))
    angle_diff_range = max(angle_diff_range, 5)
    axs[1].set_ylim([-angle_diff_range*1.2, angle_diff_range*1.2])

    analemma_trail = axs[2].plot([0], [0], c="k")[0]
    analemma_curr = axs[2].plot([0], [0], c="r", marker="o")[0]
    axs[2].set_xlim([-az_max*1.2, az_max*1.2])
    axs[2].set_ylim([-el_max*1.2, el_max*1.2])
    axs[2].set_xlabel("Ost/West-Position")
    axs[2].set_ylabel("Nord/Süd-Position")
    axs[2].set_aspect('equal')


    fig.set_size_inches(16,8)

    def update(frame, last_frame=False):
        # frame = (YEAR_LENGTH*SUBRES)
        i = frame % ((YEAR_LENGTH*SUBRES) + 1)
        if i % SUBRES == 0 or last_frame:
            day = i // SUBRES
            print(day)
            for d in range(day+1):
                day_sightlines[d].set_alpha(0.2)

            eq_time_marker.set_xdata([day])
            eq_time_marker.set_ydata([angle_diff[day]])
            
            analemma_trail.set_xdata(az[:day+1])
            analemma_trail.set_ydata(el[:day+1])
            analemma_curr.set_xdata([az[day]])
            analemma_curr.set_ydata([el[day]])
        x = x_smooth_vals[i]
        y = y_smooth_vals[i]
        angle = angles[i]
        earth.set_xdata([x])
        earth.set_ydata([y])
        sx, sy = get_sightline_xy(x, y, angle, 5)
        earth_dir.set_xdata(sx)
        earth_dir.set_ydata(sy)
        return (earth, earth_dir)
    fig.tight_layout()

    filename = f"anim-{YEAR_LENGTH}-{str(EXCENTRICITY).replace('.', '_')}-{str(AXIAL_TILT).replace('.', '_')}"
    if last_frame_only:
        update((YEAR_LENGTH*SUBRES), True)
        fig.savefig(filename + ".svg")
        return

    ani = animation.FuncAnimation(fig=fig, func=update, frames=(YEAR_LENGTH*SUBRES) + 1, interval=80)
    #plt.show()
    print("Saving animation", filename)
    ani.save(filename=filename + ".mp4", writer="ffmpeg")
    print("Done")

e = 0.01
only_last = False

# make_animation(0, 0, only_last)
# make_animation(0.1, 0, only_last)
# make_animation(e, 0, only_last)
# make_animation(0, 23.5, only_last)
# make_animation(e, 23.5, only_last)
make_animation(0.04, 23.5, only_last)
make_animation(0.2, 23.5, only_last)