// Get Polylux from the official package repository
#import "@preview/polylux:0.4.0": *
#import "@preview/muchpdf:0.1.0": muchpdf

// Make the paper dimensions fit for a presentation and the text larger
#set page(paper: "presentation-16-9", margin: 1cm)
#set text(size: 25pt, font: "Lato")

// Use #slide to create a slide and style it using your favourite Typst functions
#slide[
  #set align(horizon)
  = Analemma und Zeitgleichung

  Jakob Staudt

  1.07.2025
]

#slide[
  == Das Analemma

  #set align(center)
  #image("images/analemma.png", height: 1fr)
  // https://commons.wikimedia.org/wiki/File:Analemma_A14_2016_%2825907420783%29.jpg
]

#slide[
  == Das Analemma

  #set align(center)
  #image("images/Analemma_Earth.png", height: 1fr)
  // https://commons.wikimedia.org/wiki/File:Analemma_Earth.png

  #pdfpc.speaker-note(
    ```md
    - Analemma = Pfad der Sonne zu gleicher Ortszeit
    - Acht-Förmig
    
    Wie entsteht das?
    ```
  )
]

#slide[
  == Ein einfaches Beispiel

  #set align(horizon)
  - Ein Jahr dauert 32 Tage
  - Beobachter sitzt auf Äquator
  - *Keine Achsneigung*
  - *Kreisorbit (e=0)*

  #pdfpc.speaker-note(
    ```md
    - Kreisorbit ohne Achsneigung
    Video anim-32-0-0.mp4
    ```
  )
]

#slide[
  == Exzentrizität

  #set align(horizon)
  - Ein Jahr dauert 32 Tage
  - Beobachter sitzt auf Äquator
  - *Keine Achsneigung*
  - *Orbit mit Exzentrizität (e=0.1)*

  #pdfpc.speaker-note(
    ```md
    - Jetzt mit Exzentrizität von 0,1
    Video anim-32-0_1-0.mp4
    ```
  )
]

#slide[
  == Achsneigung

  #set align(horizon)
  - Ein Jahr dauert 32 Tage
  - Beobachter sitzt auf Äquator
  - *23,5° Achsneigung*
  - *Kreisorbit (e=0)*
  #pdfpc.speaker-note(
    ```md
    - Jetzt mit Achsneigung von 23,5°
    Video anim-32-0-23_5.mp4
    ```
  )
]

#slide[
  == Exzentrizität & Achsneigung

  #set align(horizon)
  - Ein Jahr dauert 32 Tage
  - Beobachter sitzt auf Äquator
  - *23,5° Achsneigung*
  - *Orbit mit Exzentrizität (e=0.01)*
  #pdfpc.speaker-note(
    ```md
    - Jetzt beides zusammen, aber Exzentrizität nur 0,01 damit Effekt wie bei Erde
    Video anim-32-0_01-23_5.mp4
    ```
  )
]

#slide[
  == Exzentrizität & Achsneigung

  #set align(center)
  #image("images/anim-32-0_01-23_5.svg", height: 1fr)
]

#slide[
  == Vorkommen

  #toolbox.side-by-side[
    #set align(horizon)
    #image("images/Munich_Altes_Rathaus_sundial.jpg")
    // https://de.m.wikipedia.org/wiki/Datei:Munich_Altes_Rathaus_sundial.jpg
  ][
    #set align(center)
    #image("images/gnomon.jpg", height: 1fr)
    // https://www.nmsundials.com/Gnomon.htm
  ]

  #pdfpc.speaker-note(
    ```md
    - Analemma muss bei Sonnenuhr berücksichtigt werden
    - Entweder durch Form des Gnomons (Zeigers) der Sonnenuhr oder durch Markierungen am Ziffernblatt
    ```
  )
]

#slide[
  == Die Zeitgleichung

  #set align(center)
  #image("images/Zeitgleichung.png", height: 1fr)
  // https://commons.wikimedia.org/wiki/File:Zeitgleichung.png

  #pdfpc.speaker-note(
    ```md
    Zeitgleichung zeigt Zeitversatz des Analemmas über Tag des Jahres (d. h. nur X-Achse des Analemmas über Zeit)
    ```
  )
]

#slide[
  == Einfluss der Uhrzeit

  #set align(center)
  #image("images/Sonnenstandsdiagramm_Muenchen_300dpi.png", height: 1fr)
  // https://commons.wikimedia.org/wiki/File:Sonnenstandsdiagramm_Muenchen_300dpi.png

  #pdfpc.speaker-note(
    ```md
    Zeitgleichung zeigt Zeitversatz des Analemmas über Tag des Jahres (d. h. nur X-Achse des Analemmas über Zeit)
    ```
  )
]

#slide[
  == "Analemma" am Boden

  #toolbox.side-by-side[
    #set align(center)
    #image("images/qzss.jpeg", height: 1fr)
    // https://commons.wikimedia.org/wiki/File:Qzss-45-0.09.jpg
  ][
    - Bodenspur von SSOs
  ]
]

#slide[
  == "Analemma" am Boden

  #set align(center)
  #image("images/groundtracks.png", height: 1fr)
  // https://www.researchgate.net/figure/Satellite-ground-tracks-The-blue-and-red-lines-represent-the-ground-tracks-of-the-IRNSS_fig1_328852809

]

#slide[
  == Auf anderen Planeten - Merkur

  #set align(center)
  // #image("images/Mars_analemma.GIF", height: 1fr)
  #muchpdf(read("images/Mercury-an.pdf", encoding: none), height: 1fr)
]

#slide[
  == Auf anderen Planeten - Venus

  #set align(center)
  // #image("images/Mars_analemma.GIF", height: 1fr)
  #muchpdf(read("images/Venus-an.pdf", encoding: none), height: 1fr)
]


#slide[
  == Auf anderen Planeten - Mars

  #set align(center)
  // #image("images/Mars_analemma.GIF", height: 1fr)
  #muchpdf(read("images/Mercury-an.pdf", encoding: none), height: 1fr)
]

#slide[
  == Auf anderen Planeten - Jupiter

  #set align(center)
  // #image("images/Mars_analemma.GIF", height: 1fr)
  #muchpdf(read("images/Jupiter-an.pdf", encoding: none), height: 1fr)
]

#slide[
  == Auf anderen Planeten - Saturn

  #set align(center)
  // #image("images/Mars_analemma.GIF", height: 1fr)
  #muchpdf(read("images/Saturn-an.pdf", encoding: none), height: 1fr)
]

#slide[
  == Auf anderen Planeten - Uranus

  #set align(center)
  // #image("images/Mars_analemma.GIF", height: 1fr)
  #muchpdf(read("images/Uranus-an.pdf", encoding: none), height: 1fr)
]

#slide[
  == Auf anderen Planeten - Neptune

  #set align(center)
  // #image("images/Mars_analemma.GIF", height: 1fr)
  #muchpdf(read("images/Neptune-an.pdf", encoding: none), height: 1fr)
]

#slide[
  == Auf anderen Planeten - Pluto

  #set align(center)
  // #image("images/Mars_analemma.GIF", height: 1fr)
  #muchpdf(read("images/Pluto-an.pdf", encoding: none), height: 1fr)
]

#slide[
  == Quellen

  #set align(horizon)
  - https://en.wikipedia.org/wiki/Analemma
  - https://www.youtube.com/watch?v=W8pLBMYm6Ko
  - https://pbarbier.com/eqtime/eqtime.html
  - https://www.nmsundials.com/Gnomon.htm
]