clc;
clear;
close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Koordinaten- und Zeitsysteme
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Selbstgewählte Parameter:
% Jahr;
year = 2025;

% Ort:
loc = 'Berlin';
Phi = 52.5200;
Lambda = 13.4050;

% Abstand Weltzeit (UTC) in Stunden
h = 1;


%% Bewegung der Sonne

% Zeitvariable:
time_loc = linspace(0,24,2881);

% Frühlingsanfang
y = year;
m = 03;
d = 20;
season = 'Frühlingsanfang';

% Weltzeit Greenwitch
ut1_vec = time_loc-h;

% Berechnung des lokalen Sonnenstands
moveSun(y,m,d,ut1_vec,time_loc,Phi,Lambda,loc,season);

% Sommeranfang
y = year;
m = 06;
d = 21;
season = 'Sommeranfang';

% Weltzeit Greenwitch
ut1_vec = time_loc-(h+1);

% Berechnung des lokalen Sonnenstands
moveSun(y,m,d,ut1_vec,time_loc,Phi,Lambda,loc,season);


% Winteranfang
y = year;
m = 12;
d = 21;
season = 'Winteranfang';

% Weltzeit Greenwitch
ut1_vec = time_loc-(h+1);

% Berechnung des lokalen Sonnenstands
moveSun(y,m,d,ut1_vec,time_loc,Phi,Lambda,loc,season);

