from math import floor, pi, sin, cos, atan2, asin

def nutwink(t):
    d  =  t * 36525

    f1 = (125 - 0.05295 * d) / 180 * pi
    f2 = (200.9 + 1.97129 * d) / 180 * pi

    eps0   = (84381.448 - 46.815 * t) / 3600
    delpsi = (-0.0048 * sin(f1) - 0.0004 * sin(f2))
    deleps = ( 0.0026 * cos(f1) + 0.0002 * cos(f2))

    return eps0,deleps,delpsi

def prezwink(t):
    zetaa  = (2306.2181 * t + 0.30188 * (t**2))/3600
    za     = (2306.2181 * t + 1.09468 * (t**2))/3600
    thetaa = (2004.3109 * t - 0.42665 * (t**2))/3600

    return za,thetaa,zetaa


def julianjh(y,m,d,ut1):
   jd  = 367*y - floor(7*(y+floor((m+9)/12))/4)
   jd  = jd + floor(275*m/9) + d + 1721014 + ut1/24 - 0.5
   t   = (jd-2451545)/36525
   mjd =  jd-2400000.5
   return t, mjd, jd


def rem(a, b):
    return a % b

def jul2gast(ut1, t):
    gmst = (ut1*3600 + 24110.54841 + 8640184.812866*t + 0.093104*(t**2)
            - 6.2e-6*(t**3)) /3600
    [eps0,deleps,delpsi] = nutwink(t)
    epsi = (eps0 + deleps) / 180 * pi
    eq   = delpsi * cos(epsi)
    gast = gmst + eq/15
    gast = rem(rem(gast,24)+24,24)
    gmst = rem(rem(gmst,24)+24,24)

    return gast, gmst

def solarpos(t):

    Lo   = 280.46645 + 36000.76983*t + 0.0003032*(t**2)

    M    = 357.52910 + 35999.05030*t - 0.0001559*(t**2)
    M    = M*pi/180

    e    = 0.016708617 - 0.000042037*t - 0.0000001236*(t**2)

    C    = (1.9146-0.004817*t-0.000014*(t**2))*sin(M) + (0.019993-0.000101*t)*sin(2*M) + 0.00029*sin(3*M)

    Ltru = Lo + C
    v    = M + C*pi/180


    r    = 1.000001018*(1-(e**2))/(1+e*cos(v))

    om   = 125.04 - 1934.136*t
    om   = om * pi/180
    Lapp = Ltru - 0.00569 - 0.00478*sin(om)
    Lapp = Lapp * pi/180

    [eps0,deleps,delpsi] = nutwink(t)
    eps  = ( eps0 + 0.00256*cos(om) ) *pi/180

    aapp = atan2((cos(eps)*sin(Lapp)),cos(Lapp))
    aapp = rem(aapp*180/pi+360,360)
    dapp = asin(sin(eps)*sin(Lapp))*180/pi

    return aapp,dapp,r
