import math

def skyplot(plt, elevation_values, azimuth_values):
    prev_elev = None

    elev_segments = []
    elev_seg = []
    azim_segments = []
    azim_seg = []
    segment_state = []

    for elev, azim in zip(elevation_values, azimuth_values):
        SUNRISE_THRESH = -0.25

        if prev_elev and prev_elev < -SUNRISE_THRESH and elev > -SUNRISE_THRESH:
            elev_segments.append(elev_seg.copy())
            elev_seg = []
            azim_segments.append(azim_seg.copy())
            azim_seg = []
            segment_state.append("night")

        if prev_elev and prev_elev > -SUNRISE_THRESH and elev < -SUNRISE_THRESH:
            elev_segments.append(elev_seg.copy())
            elev_seg = []
            azim_segments.append(azim_seg.copy())
            azim_seg = []
            segment_state.append("day")

        elev_seg.append(elev)
        azim_seg.append(azim)

        prev_elev = elev

    if elev_seg:
        elev_segments.append(elev_seg)
        azim_segments.append(azim_seg)
        segment_state.append("day" if segment_state[-1] == "night" else "night")


    fig, ax = plt.subplots(subplot_kw={'projection': 'polar'})
    ax.set_theta_zero_location("N")
    ax.axhline(0, color="k").get_path()._interpolation_steps = 180
    ax.set_ylim(90, -90)
    for elev, azim, s in zip(elev_segments, azim_segments, segment_state):
        #print(elev)
        #print(azim)
        color = "r" if s == "day" else "b"
        print(len(elev))
        print(color)
        ax.plot([math.radians(v) for v in azim], elev, c=color)
    return fig