#set heading(numbering: "1.")
#set text(lang: "de")
#show heading: set block(below: 1.25em, above: 1.75em)
#set page(numbering: "1")


#v(2cm)
#align(center)[
  #text(size: 18pt, weight: "bold",
    [
    Semesterabgabe \
    Koordinaten- und Zeitsysteme in der Geodäsie, \ Luft- und Raumfahrt
    ]
  )
]
#v(2cm)

#align(center)[
  #text(size: 14pt, weight: "regular", [
  Sommersemester 2025
  ])
]

#v(3cm)

#text(size: 14pt, weight: "regular", [
#align(center)[
  #grid(
      columns: (1fr, 1fr, 1fr),
      rows: (auto),
      gutter: 1pt,
      [Ferdinand Gerstenberger \ 3311466],
      [Jakob Staudt \ 3526264],
      [Thomas Westermeier \ 3758676],
  )
]
])
#v(3cm)

#align(center)[
  #text(size: 14pt, weight: "regular", [
  22. Juli 2025
  ])
]
#pagebreak()

= Aufgabe - Bewegung der Sonne

Am Anfang der Aufgabe soll ein Ort auf der Erde gewählt werden und für diesen der Sonnenverlauf am Frühlings-, Sommer- und Winteranfang für ein freigewähltes Jahr bestimmt werden. Hierfür wird Berlin mit Längengrad 52.520° und Breitengrad 13.405° als Ort gewählt.
Außerdem wird das aktuelle Jahr 2025 für den Sonnenverlauf genommen.

Um die Rektaszension $alpha$ und Deklination $delta$ der Sonne für den Frühlingsanfang am 20.03. bestimmen zu können muss die Zeit in die Weltzeit UT1 umgerechnet werden.
Anschließend können mit julianjh.m und solarpos.m die Sonnendaten im inertialen System bestimmt werden. Um aber die Elevation und Azimut, welche im lokalen erdfesten System definiert sind, zu bestimmen, müssen einige Transformationen durchgeführt werden. Zuerst müssen Präzession und Nutation der Erde bestimmt werden.
Diese werden mittels prezwink.m und nutwink.m bestimmt. Anschließend muss das System um die beiden Winkel rotiert werden.

$ N = R_1(-epsilon - Delta epsilon) dot R_3(-Delta psi) dot R_1(epsilon) $
$ P = R_3(-z) dot R_2(theta) dot R_3(- zeta_0) $

Zusätzlich wird noch mit jul2gast.m die GAST (Greenwich Actual Siderial Time) bestimmt und um vom globalen ins lokale zu kommen um $Phi$ und $Lambda$ gedreht. Das führte zu folgender Transformation:

$ r^g = R_2(90°-Phi) dot  R_3(Lambda) dot ((R_3("GAST") dot N dot P dot r_0 $

Da die Transformation nur in kartesischen Koordinaten umgesetzt werden kann muss vor und nach der Transformation die Rektaszension und Deklination beziehungsweise die lokalen Koordinaten in Elevation und Azimut umgewandelt werden. 
Um Rektaszension und Deklination in inertiale Koordinaten umzuwandeln, kann folgender Vektor berechnet werden.

$ r_0 = [cos(delta) dot cos(alpha), cos(delta) dot sin(alpha), sin(delta)] $

Die Elevation und Azimut können dann mittels skyplot.m visualisiert werden. Die Skyplots für den Frühlings- (20.03.), Sommer- (21.06) und Winteranfang (21.12.) sind in @frueplot, @sommplot und @winterplot zu sehen.

#figure(
  image("output/fruehling.svg", width: 80%),
  caption: [Skyplot für den Frühlingsanfang (20.03)],
) <frueplot>

#figure(
  image("output/sommer.svg", width: 80%),
  caption: [Skyplot für den Sommeranfang (21.06)],
) <sommplot>

#figure(
  image("output/winter.svg", width: 80%),
  caption: [Skyplot für den Winteranfang (21.12)],
) <winterplot>

Für die Bestimmung der Tageslänge müssen zuerst Sonnenaufgang und Sonnenuntergang definiert werden.
Nach der einfachsten Definition zählt die Zeit als Tag in der die Sonne eine Elevation über 0 Grad besitzt.
Das entspricht bildlich der Zeit in der die Mitte der Sonnenscheibe nicht unter dem Horizont liegt, wenn der Beobachter auf Bodenhöhe steht.
Allerdings ist mit Sonnenaufgang normalerweise der Zeitpunkt gemeint an dem die Oberkante der Sonnenscheibe sichtbar wird. Daher muss die Elevation bei einer scheinbaren Sonnengröße von 0,5° nur über -0,25° um als Aufgegangen zu zählen.
Außerdem erscheint die Sonne in Horizontnähe durch Lichtkrümmung in der Atmosphäre ca. 0,6° höher. Daher wird die Oberkante der Sonne schon ab einer Elevation von -0,85° sichtbar.
Wenn der Tagesbeginn als beginn der bürgerlichen Dämmerung definiert ist beginnt der Tag schon sobald die Sonne eine Elevation von -6° überschreitet.

Bei Betrachtung der berechneten Sonnenverläufe fällt auf, dass Sonnenaufgang und Sonnenuntergang (Elevation = 0) leicht von den Internetdaten #cite(<timeanddate>) abweichen. 
Die Unterschiede liegen zwischen 10 und 15 Minuten bei den Uhrzeiten und bei der Tageslänge zwischen sechs und neun Minuten. Die Abweichungen könnten unter anderem daher kommen, dass die Polverschiebung hier noch nicht berücksichtigt wird.
Jedoch sind die Unterschiede recht hoch, sodass dieses nicht alleine von der Polverschiebung herrühren kann.

Der Unterschied kann allerdings auch nicht hauptsächlich durch eine abweichende Sonnenauf- und Untergangs-Definition erklärt werden, da diese eine ungefähr Betragsmäßig gleiche und entgegengesetzte Auswirkung auf die Zeit des Sonnenaufgangs und Untergangs hätte. Im Vergleich mit den Internetdaten sind die Zeiten für Sonnenauf- und Untergang allerdings unterschiedlich verschoben.


= Aufgabe - Polbewegung

Die Daten für die Polbewegung wurden von #cite(<iers_file>) geladen.
Die Datei enthält unter anderem die Drehung der Erdachse relativ zu der durch den IERS-Referenzpol laufenden Referenzachse in X-Richtung (entlang dem ITRF-Nullmeridian) und Y-Richtung (Senkrecht dazu Richtung Westen) #cite(<iers_expl>).
Die Daten reichen von 1900 bis Mitte 2025 und werden in 0,05-Jahr-Schritten angegeben.


== Räumliche Darstellung

#figure(
  image("output/fig2_1.svg", width: 80%),
  caption: [Polspur],
) <PolarMotionOverlaid>

In @PolarMotionOverlaid ist die Spur der Erdpols in X- und Y-Koordinate aufgetragen. Der Farbverlauf stellt den Zeitverlauf von 1900 bis 2025 dar.
Man erkennt eine Kreisende Bewegung und eine langfristige Bewegung in Richtung positiver X- und Y-Werte.

#figure(
  image("output/fig2_2.svg", width: 80%),
  caption: [X- und Y-Bewegung des Pols mit Zeit als Z-Achse],
) <PolarMotion3D>

#figure(
  image("output/fig2_3.svg", width: 80%),
  caption: [X-Bewegung des Pols entlang der Zeit],
) <PolarMotion3D_X>

#figure(
  image("output/fig2_4.svg", width: 80%),
  caption: [Y-Bewegung des Pols entlang der Zeit],
) <PolarMotion3D_Y>

In @PolarMotion3D ist die Spur des Pols in einem dreidimensionalen Plot dargestellt, wobei die Z-Achse der Zeit entspricht. Die Zeit verläuft hierbei in positive Z-Richtung.
In @PolarMotion3D_X und @PolarMotion3D_Y sind die Projektionen des 3D-Plots entlang der Y- und X-Achse dargestellt, d. h. die X- und Y-Drehung des Pols über die Zeit.
Die Rote Kurve stellt jeweils den Mittelwert der letzten 200 Werte, d. h. der letzten 10 Jahre dar.

Die säkulare Polbewegung (d. h. die langfristige auf dieser Zeitskala nichtperiodische Bewegung) ist in den roten Kurven gut erkennbar. Sie führt zu einer leichten Wanderung des Pols in Richtung Nullmeridian und einer stärkeren Wanderung des Pols Richtung Westen.

== Zeitliche Darstellung

Zur Analyse der Polbewegung kann auch eine Spektralanalyse durchgeführt werden.
So können regelmäßigkeiten in den Daten erkannt werden.
Die Ergebnisse einer Spektralanalyse mit dem Welch-Algorithmus sind in @PolarMotionSpectrumX und @PolarMotionSpectrumY gezeigt. Hierbei wurden jeweils die X- und Y-Koordinaten der Polbewegung als einzelne Zeitreihen analysiert.

#figure(
  image("output/fig2_5.svg", width: 80%),
  caption: [Spektrum der X-Koordinate],
) <PolarMotionSpectrumX>

#figure(
  image("output/fig2_6.svg", width: 80%),
  caption: [Spektrum der Y-Koordinate],
) <PolarMotionSpectrumY>


Man erkennt eine jährliche Schwingung (Blau) und eine Schwingung mit einer Periode von ca. 433 Tagen (Rot). 

Die Jährliche Schwingung (bzw. Kreisbewegung des Pols) wird durch eine Verschiebung von Masse in der Atmosphäre verursacht.

Die langsamere Schwingung mit einer Periode von ca. 433 Tagen wird nach ihrem Entdecker Seth Carlo Chandler "Chandler Wobble" genannt.
Das Chandler-Wobbeln wird durch eine Kombination von Atmosphären- und Ozean-Schwankungen verursacht, wobei der Haupteffekt durch die Ozeane entsteht #cite(<gross_excitation_2000>).

= Aufgabe - Mega-Konstellation im lokalen System

== Koordinatensysteme

Für moderen Satelliten-Kommunikationsnetzwerke wie Starlink umkreisen tausende Satelliten die Erde. Die Bahndaten dieser Satelliten werden durch Webservices wie celestrak.org und satdb.ethz.ch in der Form vom Two Line Elements (TLEs) verfügbar gemacht. 
Two Eine Elements sind eine durch die Verarbeitung mittels Lockhkarten begründete Darstellungsart der Keplerbahn eines Satelliten. Darin werden alle sechs Bahnelemente für eine definierte Epoche kodiert. Für die Bewegung des Satelliten auf seiner Bahn als Mean Motion werden auch die ersten und zweiten Ableitungen angegeben. 

Aus diesem Datensatz lassen sich nun mittels einens Propagationsmodells die Satellitenpositionen in der Nähe der Epoche bestimmen. Für Propagierung der TLEs mittels des SGP4-Modells existieren Standardimplementierungen. Hierbei muss nur das entsprechende TLE und der zu berechnende Zeitpunkt als julianischer Tag und Tagesbruchteil angegeben werden und es wird die dreidimensionale Position des Satelliten im Raum zurückgegeben.

Das für diese Position verwendete Koordinatensystem wird in #cite(<AIAA4025>) beschrieben. Demzufolge handelt es sich um das TEME-System. TEME steht für True Equator Mean Equinox. Es wird also auf den wahren Äquator referenziert, dh. die Präzession ist bereits mit eingerechnet. Die Verschiebung durch die Nutuation muss noch berücksichtigt werden, um zu einem instantanen inertialen Koordinatensystem zu kommen.

Zur besseren Veranschaulichung ist diese Verschiebung dargestellt in Abbildung 1. in #cite(<AIAA4025>) in die @TEME aus der Vorlesung #cite(<sneeuw2018>) eingefügt. Es lässt sich erkennen, dass um von $\u{2648}_"TEME"$ zu $\u{2648}_"T"$ zu transformieren eine Rotation $R_3$ um $Delta psi cos (epsilon + Delta epsilon)$ notwendig ist.

#figure(
  image("output/TEME.png", width: 80%),
  caption: [Tranformation von $\u{2648}_"TEME"$ zu $\u{2648}_"T"$],
) <TEME>

Die TLEs werden von satdb.ethz.ch für den 1.1.2024 heruntergeladen. Dieser Zeitpunkt ist so gewählt, da diese Seite zur Zeit anscheinend nicht aktuell gehalten wird. Anschließend werden die TLEs nach Satelliten gefiltert und jeweils das erste an dem Tag verfügbare TLE pro Satellit beibehalten. Es ergeben sich damit 5128 Satelliten, für die die Bahnen propagiert werden.

Es wird zuerst ein einzelner Satellit betrachtet. Der ausgewählte Satellit ist STARLINK-30965 mit dem NORAD-Designator 58477 und einer Inklination von 43°.
Die Position von der aus der Satellit beobachtet wird ist für diese Aufgabe festgelegt als Castello de la Plana mit einem Längengrad von 40,0° einem Breitengrad von 0,0° und der Höhe 0m.

In @SingleSatInertial ist die Bahn des Satelliten im Inertialraum dargestellt, zusammen mit einer Kugel mit mittlerem Erdradius zur Orientierung.Das Zeitinterval der dargestellten ist der 1.1.2024 von 0 bis 24 Uhr.

#figure(
  image("output/1.3_inertial_3D.svg", width: 80%),
  caption: [Bahn des Sateliten im TEME Inertialraum],
) <SingleSatInertial>

Zur Transformation des Satellitenbahn vom inertialen ins topozentrische System werden folgende Transformation angewandt.

$ r^g = R_2(90°-Phi) dot  R_3(Lambda) dot ((R_3("GAST") dot R_3(Delta psi cos (epsilon + Delta epsilon)) dot r^"TEME") -r_0) $
Die Position $r_0$ wird dabei aus der Länge, Breite, Höhe auf dem GRS80 Ellipsoid berechnet.

In @SingleSatTerrestrial ist die Bahn im erdfesten System dargestellt. Der Ursprung liegt hierbei ganz oben auf der dargestellten Kugel.

#figure(
  image("output/1.3_terrestrial_3D.svg", width: 80%),
  caption: [Bahn des Satelliten im terrestrischen System],
) <SingleSatTerrestrial>

Der Skyplot diese Satelliten ist in @SingleSatSkyplot dargestellt. Da die Bahnneigung mit 43° nur gering größer ist als die Breite des Beobachters mit 40°, gibt es einige Überflüge im Zenit und einige südlich des Beobachters.

#figure(
  image("output/1.3_Skyplot_single.svg", width: 80%),
  caption: [Skyplot des Satelliten],
) <SingleSatSkyplot>

Die Zeiten für die der Satellit sichtbar ist können aus der Elevation berechnet werden. Die einfachste Definition von "sichtbar" ist wenn der Satellit eine Elevation > 0° hat. Wird diese Bedingung angewendet erhält man eine boolsche Maske für die Sichtbarkeit bei allen Zeitpunkten. Wechselt der Sichtbarkeitswert von Falsch auf Wahr steigt der Satellit über den Horizont. Beim Wechsel von Wahr auf Falsch geht er unter. Durch Einsetzen dieser Indices in das Array der Zeitpunkte können die Auf-und Untergangszeiten bestimmt werden. Die Zeit für die der Satellit sichtbar ist ist deren Differenz.


/*
#align(center, block[
  #set align(left)
  Sichtbar ab:  0.3912h  für: 0.1776h  bis:  0.5688h\
  Sichtbar ab:  2.0112h  für: 0.1800h  bis:  2.1912h\
  Sichtbar ab:  3.6360h  für: 0.1824h  bis:  3.8184h\
  Sichtbar ab:  5.2608h  für: 0.1824h  bis:  5.4432h\
  Sichtbar ab:  6.8904h  für: 0.1536h  bis:  7.0440h\
  Sichtbar ab: 22.0104h  für: 0.0792h  bis: 22.0896h\
  Sichtbar ab: 23.5752h  für: 0.1728h  bis: 23.7480h
])
*/
#v(0.3cm)
#align(center, table(
  columns: (auto, auto, auto),
  inset: 10pt,
  align: horizon,
  table.header(
    [*sichtbar von \[h\]*], [*sichtbar bis \[h\]*], [*Sichtbarkeitsdauer \[h\]*],
  ),
  [0.3912], [0.5688], [0.1776],
  [2.0112], [2.1912], [0.1800],
  [3.6360], [3.8184], [0.1824],
  [5.2608], [5.4432], [0.1824],
  [6.8904], [7.0440], [0.1536],
  [22.0104], [22.0896], [0.0792],
  [23.5752], [23.7480], [0.1728]
)
)
#v(0.3cm)
In @SingleSatAzimuth ist der Azimut des Satelliten über die Zeit aufgetragen. Zwischen 0 und 5 Uhr kommt es zu annähernd zenitalen Überflügen, die sich in rapiden Azimutwechseln deutlich machen.

#figure(
  image("output/1.3_Azimuth_Time_single_single.svg", width: 80%),
  caption: [Azimut des Satelliten über Zeit],
) <SingleSatAzimuth>

Die Überflüge sind auch in @SingleSatElevation deutlich zu erkennen. Der Satellit nähert sich hierbei bis zu 20° dem Zenit an.

#figure(
  image("output/1.3_Elevation_Time_single.svg", width: 80%),
  caption: [Zenitwinkel des Satelliten über Zeit ],
) <SingleSatElevation>

= Aufgabe - Visualisierung

== Bodenspur

Für die Erstellung der Bodenspur wird die abschließende Rotation um Länge ($Lambda$) und Breite ($Phi$) des Beobachter weggelassen. Anschließend werden aus den Koordinaten x,y,z die Länge $lambda$ und Breite $phi$ der Satelliten berechnet.

In @BodenspurenSatellit ist die Bodenspur des Beispielsatelliten über den Zeitraum von 180 Minuten also ca. 2 Orbits startend um 0 Uhr aufgetragen.

#figure(
  image("output/1.3_GroundplotsSingleSat.svg", width: 80%),
  caption: [Bodenspuren eines einzelnen Satelliten],
) <BodenspurenSatellit>

In @BodenspurenKonstellation ist die instante Bodenspur der gesamten Starlink Konstellation um 0 Uhr dargestellt. Es sind gut erkennbar die vielen Satelliten in niedrig inklinierten Orbits und weiter Satellite zur Abdeckung der Polregionen. Hierbei ist zu beachten, dass durch die Merkatorprojektion Flächen an den Polen und damit die Abdeckung durch die Satelliten kleiner erscheinen als am Äquator.
Gut zu erkennen sind auch zwei Gruppen an Satelliten in der rechten Bildhälfte, die genau auf einer Linie liegen. Diese wurden zu diesem Zeitpunkt erst kürzlich gestartet und haben sich noch nicht auf ihrer Bahnebene verteilt. 

#figure(
  image("output/1.3_GroundplotsConstellation.svg", width: 80%),
  caption: [Instantane Positionen der gesamten Starlink-Konstellation],
) <BodenspurenKonstellation>


== Kamera

Zur Simulation einer Kamera mit 10° Field of View (FOV) wird eine Blickrichtung in Elevation und Azimut festgelegt. Das Koordinatensystem wird um den Azimutwinkel in $R_3$ und anschließend um den Elevationswinkel in $R_2$ gedreht. Damit liegt die X-Achse die neuen Koordinatensystems in der Blickrichtung. Würde mann diese Transformation nicht durchführen, würde das sich Sichtfeld bei größeren Elevationen verzerren. Die minimalen und maximalen Werte für Elevation und Azimut ergeben sich dann jeweils $plus.minus"FOV"/2$. Werden nun die berechneten Satellitenpositionen entsprechend dieser Grenzen gefiltert und die verbleibenden Werte über Elevation und Azimut geplottet, so ergibt sich das Sichtfeld der Kamera.

#figure(
  image("output/1.3_Camera_180_40_1min.svg", width: 80%),
  caption: [Simulation einer Kamera mit 10° FOV und 1 Minute Belichtung],
) <Kamera>


== Konstellation im Inertialraum

Plottet man wie in @ConstellatioInertia gezeigt die Satellitenpositionen im TEME-Inertialraum ist gut zu erkennen, dass die Satelliten jeweils Gruppen mit gleicher Orbitausrichtung bilden. Dies lässt sich damit begründe, dass bei einem Start viele Satelliten in einer Bahnebene ausgesetzt werden, und dort auch verbleiben. Sie bewegen sich nur auf der Bahnebene und führen keine Inklinationswechsel durch. Zur besseren Übersicht sind nur die ersten 200 Satelliten dargestellt.

#figure(
  image("output/1.3_inertial_3D_all.png", width: 80%),
  caption: [200 Starlink Satelliten im Inertialraum],
) <ConstellatioInertia>

#bibliography("works.bib")
